/**
 * @file version.hpp
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief Version numbers
 * 
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#include "version.h"

namespace brainaccess::core
{
	/**
	 * @brief Struct describing version numbers
	 * 
	 * @details Uses semantic versioning
	 */
	typedef ba_version version;

	/**
	 * @brief Check if versions are compatible
	 * 
	 * @details Uses semantic versioning
	 * 
	 * @param expected 
	 * @param actual 
	 * @return `true` if compatible
	 */
	[[maybe_unused]] [[nodiscard]] static bool is_version_compatible(const version& expected, const version& actual) noexcept
	{
		return ba_is_version_compatible(&expected, &actual);
	}
}
