/**
 * @file error.hpp
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief Error codes
 * 
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#include "error.h"

namespace brainaccess::core
{
	/**
	 * @brief Error codes
	 */
	enum class error : ba_error
	{
		OK = BA_ERROR_OK,                 ///< Successful
		CONNECTION = BA_ERROR_CONNECTION, ///< Connection error
		UNSUPPORTED_DEVICE = BA_ERROR_UNSUPPORTED_DEVICE, ///< Unsupported device
		UNKNOWN = BA_ERROR_UNKNOWN        ///< Unknown error
	};
}
