/**
 * @file callbacks.h
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief Callback function typedefs 
 * 
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#ifndef __cplusplus
    #include <stdbool.h>
#endif //__cplusplus
#include <stddef.h>
#include "battery_info.h"
#include "full_battery_info.h"

typedef void(* ba_callback_chunk)(const void* const*, size_t, void*);
typedef void(* ba_callback_battery)(const ba_battery_info*, void*);
typedef void(* ba_callback_disconnect)(void*);

typedef void(* ba_callback_future_void)(void*);
typedef void(* ba_callback_future_bool)(bool, void*);
typedef void(* ba_callback_future_float)(float, void*);
typedef void(* ba_callback_future_full_battery_info)(const ba_full_battery_info*, void*);
